
<?php
namespace App\Controllers;
use App\Models\ProfilModel;

class Profil extends BaseController {
    protected $model;
    public function __construct() {
        $this->model = new ProfilModel();
        helper(['form','url']);
    }

    public function index() {
        $data['items'] = $this->model->orderBy('created_at','DESC')->findAll();
        $data['title'] = 'Profil - Daftar';
        echo view('templates/header', $data);
        echo view('admin/profil_list.php', $data);
        echo view('templates/footer');
    }

    public function create() {
        $data['title'] = 'Tambah Profil';
        if (\$this->request->getMethod() === 'post') {
            $save = $this->model->insert(\$this->request->getPost());
            return redirect()->to('/profil');
        }
        echo view('templates/header', $data);
        echo view('admin/profil_form.php', $data);
        echo view('templates/footer');
    }

    public function edit($id=null) {
        $item = $this->model->find($id);
        if (!$item) return redirect()->to('/profil');
        $data['item'] = $item;
        $data['title'] = 'Edit Profil';
        if (\$this->request->getMethod() === 'post') {
            $this->model->update($id, \$this->request->getPost());
            return redirect()->to('/profil');
        }
        echo view('templates/header', $data);
        echo view('admin/profil_form.php', $data);
        echo view('templates/footer');
    }

    public function delete($id=null) {
        if ($id) $this->model->delete($id);
        return redirect()->to('/profil');
    }

    public function import() {
        echo 'Import feature requires PhpSpreadsheet and must be executed after composer install on server.';
    }

    public function export() {
        echo 'Export feature requires PhpSpreadsheet and must be executed after composer install on server.';
    }
}
