
<?php
namespace App\Controllers;
use App\Models\NewsModel;

class News extends BaseController {
    protected $model;
    public function __construct() {
        $this->model = new NewsModel();
        helper(['form','url']);
    }

    public function index() {
        $data['items'] = $this->model->orderBy('created_at','DESC')->findAll();
        $data['title'] = 'News - Daftar';
        echo view('templates/header', $data);
        echo view('admin/news_list.php', $data);
        echo view('templates/footer');
    }

    public function create() {
        $data['title'] = 'Tambah News';
        if (\$this->request->getMethod() === 'post') {
            $save = $this->model->insert(\$this->request->getPost());
            return redirect()->to('/news');
        }
        echo view('templates/header', $data);
        echo view('admin/news_form.php', $data);
        echo view('templates/footer');
    }

    public function edit($id=null) {
        $item = $this->model->find($id);
        if (!$item) return redirect()->to('/news');
        $data['item'] = $item;
        $data['title'] = 'Edit News';
        if (\$this->request->getMethod() === 'post') {
            $this->model->update($id, \$this->request->getPost());
            return redirect()->to('/news');
        }
        echo view('templates/header', $data);
        echo view('admin/news_form.php', $data);
        echo view('templates/footer');
    }

    public function delete($id=null) {
        if ($id) $this->model->delete($id);
        return redirect()->to('/news');
    }

    public function import() {
        echo 'Import feature requires PhpSpreadsheet and must be executed after composer install on server.';
    }

    public function export() {
        echo 'Export feature requires PhpSpreadsheet and must be executed after composer install on server.';
    }
}
