
<?php
namespace App\Controllers;
use App\Models\FeedbackModel;

class Feedback extends BaseController {
    protected $model;
    public function __construct() {
        $this->model = new FeedbackModel();
        helper(['form','url']);
    }

    public function index() {
        $data['items'] = $this->model->orderBy('created_at','DESC')->findAll();
        $data['title'] = 'Feedback - Daftar';
        echo view('templates/header', $data);
        echo view('admin/feedback_list.php', $data);
        echo view('templates/footer');
    }

    public function create() {
        $data['title'] = 'Tambah Feedback';
        if (\$this->request->getMethod() === 'post') {
            $save = $this->model->insert(\$this->request->getPost());
            return redirect()->to('/feedback');
        }
        echo view('templates/header', $data);
        echo view('admin/feedback_form.php', $data);
        echo view('templates/footer');
    }

    public function edit($id=null) {
        $item = $this->model->find($id);
        if (!$item) return redirect()->to('/feedback');
        $data['item'] = $item;
        $data['title'] = 'Edit Feedback';
        if (\$this->request->getMethod() === 'post') {
            $this->model->update($id, \$this->request->getPost());
            return redirect()->to('/feedback');
        }
        echo view('templates/header', $data);
        echo view('admin/feedback_form.php', $data);
        echo view('templates/footer');
    }

    public function delete($id=null) {
        if ($id) $this->model->delete($id);
        return redirect()->to('/feedback');
    }

    public function import() {
        echo 'Import feature requires PhpSpreadsheet and must be executed after composer install on server.';
    }

    public function export() {
        echo 'Export feature requires PhpSpreadsheet and must be executed after composer install on server.';
    }
}


public function submit() {
    $data = $this->request->getPost();
    $this->model->insert($data);
    return redirect()->to('/kritik-saran')->with('success','Terima kasih atas masukan Anda.');
}
