
<?php
namespace App\Controllers;
use App\Models\UserModel;

class Auth extends BaseController {
    public function login() {
        helper('form');
        if ($this->request->getMethod() === 'post') {
            $username = $this->request->getPost('username');
            $password = $this->request->getPost('password');
            $userModel = new UserModel();
            $user = $userModel->where('username', $username)->first();
            if ($user && password_verify($password, $user['password'])) {
                session()->set([
                    'id' => $user['id'],
                    'username' => $user['username'],
                    'role' => $user['role'],
                    'isLoggedIn' => true
                ]);
                return redirect()->to('/admin');
            } else {
                $data['error'] = 'Username atau password salah';
                echo view('templates/header', $data);
                echo view('auth/login', $data);
                echo view('templates/footer');
            }
        } else {
            echo view('templates/header');
            echo view('auth/login');
            echo view('templates/footer');
        }
    }

    public function logout() {
        session()->destroy();
        return redirect()->to('/');
    }
}
