
<?php
namespace App\Controllers;
use App\Models\AnnouncementModel;

class Announcement extends BaseController {
    protected $model;
    public function __construct() {
        $this->model = new AnnouncementModel();
        helper(['form','url']);
    }

    public function index() {
        $data['items'] = $this->model->orderBy('created_at','DESC')->findAll();
        $data['title'] = 'Announcement - Daftar';
        echo view('templates/header', $data);
        echo view('admin/announcement_list.php', $data);
        echo view('templates/footer');
    }

    public function create() {
        $data['title'] = 'Tambah Announcement';
        if (\$this->request->getMethod() === 'post') {
            $save = $this->model->insert(\$this->request->getPost());
            return redirect()->to('/announcement');
        }
        echo view('templates/header', $data);
        echo view('admin/announcement_form.php', $data);
        echo view('templates/footer');
    }

    public function edit($id=null) {
        $item = $this->model->find($id);
        if (!$item) return redirect()->to('/announcement');
        $data['item'] = $item;
        $data['title'] = 'Edit Announcement';
        if (\$this->request->getMethod() === 'post') {
            $this->model->update($id, \$this->request->getPost());
            return redirect()->to('/announcement');
        }
        echo view('templates/header', $data);
        echo view('admin/announcement_form.php', $data);
        echo view('templates/footer');
    }

    public function delete($id=null) {
        if ($id) $this->model->delete($id);
        return redirect()->to('/announcement');
    }

    public function import() {
        echo 'Import feature requires PhpSpreadsheet and must be executed after composer install on server.';
    }

    public function export() {
        echo 'Export feature requires PhpSpreadsheet and must be executed after composer install on server.';
    }
}
